package gov.va.vamf.scheduling.batch.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import gov.va.vamf.scheduling.communitycare.domain.BookedCCAppointment;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CCAppointmentReminder {

    private PatientIdentifier patientIdentifier;
    private String appointmentRequestId;
    private String patientEmailAddress;
    private Date appointmentDate;
    private String practiceName;
    private String providerPhoneNumber;
    private String timeZone;
    private Date adjustedDateTime;

    public CCAppointmentReminder() {
    }

    public CCAppointmentReminder(BookedCCAppointment bookedCCAppointment) {
        this.patientIdentifier = bookedCCAppointment.getPatientIdentifier();
        this.appointmentRequestId = bookedCCAppointment.getAppointmentRequestId();
        this.appointmentDate = bookedCCAppointment.getAppointmentTime();
        this.timeZone = bookedCCAppointment.getTimeZone();
        this.practiceName = bookedCCAppointment.getProviderPractice();
        this.providerPhoneNumber = bookedCCAppointment.getProviderPhone();
        this.adjustedDateTime = createAdjustedDateTime();
    }

    public PatientIdentifier getPatientIdentifier() {
        return patientIdentifier;
    }

    public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    public String getAppointmentRequestId() {
        return appointmentRequestId;
    }

    public void setAppointmentRequestId(String appointmentRequestId) {
        this.appointmentRequestId = appointmentRequestId;
    }

    public String getPatientEmailAddress() {
        return patientEmailAddress;
    }

    public void setPatientEmailAddress(String patientEmailAddress) {
        this.patientEmailAddress = patientEmailAddress;
    }

    public Date getAppointmentDate() {
        return appointmentDate;
    }

    public void setAppointmentDate(Date appointmentDate) {
        this.appointmentDate = appointmentDate;
    }

    public String getPracticeName() {
        return practiceName;
    }

    public void setPracticeName(String practiceName) {
        this.practiceName = practiceName;
    }

    public String getProviderPhoneNumber() {
        return providerPhoneNumber;
    }

    public void setProviderPhoneNumber(String providerPhoneNumber) {
        this.providerPhoneNumber = providerPhoneNumber;
    }

    public void addNotificationPreferenceDetails(VARPatientPreference varPatientPreference) {
        this.patientEmailAddress = varPatientPreference.getEmailAddress();
    }

    public String getTimeZone() {
        return timeZone;
    }

    private int getTimeZoneOffset() {
        return Integer.parseInt(this.timeZone.split(":")[0]);
    }

    public String getTimeZoneAbbr() { return this.timeZone.split(" ")[1]; }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Date getAdjustedDateTime() {
        return adjustedDateTime;
    }

    public Date createAdjustedDateTime() {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(getAppointmentDate()); //takes care of day, month, year, minute
        calendar.add(Calendar.HOUR_OF_DAY, getTimeZoneOffset()); //fixes utc to timezone saved by
        return calendar.getTime();
    }
}
